import { Component, OnInit, Input } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../../store';
import { MvpServices } from '../../../../services/mvp-services';


@Component({
  selector: 'app-mvp-add-properties',
  templateUrl: './mvp-add-properties.component.html',
  styleUrls: ['./mvp-add-properties.component.scss']
})
export class MvpAddPropertiesComponent implements OnInit {
  @Input() tindex;
  @Input() tabType;
  @Input() mvpObject;
  selectedPredicateUri: any;
  onHoverSubmit: boolean;
  @select(['system', 'focusedElement']) focusedElement;
  constructor(
    public mvpServices: MvpServices,
    private ngRedux: NgRedux<IAppState>) { }

  ngOnInit() {
  }

  getPredicateLabelList(){
    return this.mvpServices.getPredicateLabelList();
  }

   anyPredicateExists() {
    return this.mvpServices.getPredicateLabelList() != null && this.mvpServices.getPredicateLabelList().length > 0; 
  }

   onSubmit(form) {
     var propertyInput = form.value.property.trim();
     if (this.selectedPredicateUri != null &&
      this.selectedPredicateUri.length > 0 &&
      this.selectedPredicateUri != "0" &&
      propertyInput != null && propertyInput.length > 0) {
        this.mvpObject.predicate = this.selectedPredicateUri;
        this.mvpObject.object = propertyInput;
        this.mvpServices.addMvpConcept(this.mvpObject, this.tabType);
    }
  }

}
